
libname q 'C:\SASCodeForBook\SASDataSets';
Data first; set q.adlten;

/*This code will produce the data for Table 8.9 using the Glimmix
Macro, which must be installed for this code to run.  It was 
downloaded from SAS and is presented in SAS System for Mixed Models, 
by Littell, Milliken, Stroup, and Wolfinger, 1996,505-529.
Proc Glimmix is preferred to this Macro.  However, the Macro explicitly
produces estimates of the deviance and scaled deviance, as reported in Table 8.9*/ 

Remembrance = 1 - TooMuchShoahTalk; 

Valueslife = (PAProPeace + IsraelProPeace + remembrance)/3;
ValuesJewishLife = (IsraelProPeace + remembrance)/2;
propeace = (PAProPeace + IsraelProPeace)/2;

DislikesIsrael = (IsraelAntiPeace + ViewsIsraelUnfavorably)/2;

cohesion = (ownkind + loyaltoIsrael)/2;
corruption = (shady + toomuchpower)/2;
 
RadicalRight = 0;
If country = 'Belgium' then RadicalRight = 1;
If country = 'Austria' then RadicalRight = 1;
If country = 'France' then RadicalRight = 1;
count = 500;

Reparations = 0;
If country = 'Germany' then Reparations = 1;
If country = 'Austria' then Reparations = 1;
If country = 'Switzerland' then Reparations = 1;
 
AntiPeace = (PAAntiPeace + IsraelAntiPeace)/2;

Belgium = 0;
If country = 'Belgium' then Belgium = 1;

ManyJewsMuslims = 0;
if (jewishbinary = 1 and muslimbinary = 1) then manyjewsmuslims = 1;

Twotreatments = ManyJewsMuslims;

Threetreatments = 0;
If (jewishbinary = 0 and muslimbinary = 0) then threetreatments = 3;
If (jewishbinary = 0 and muslimbinary = 1) then threetreatments = 2;
If (jewishbinary = 1 and muslimbinary = 1) then threetreatments = 1;

Yeardummy = 0;
If year = 2004 then yeardummy = 1;

Fiveyears = 0;
If year = 2001 then Fiveyears = 5;
If year = 2002 then Fiveyears = 4;
If year = 2003 then Fiveyears = 3;
If year = 2004 then Fiveyears = 2;
If year = 2005 then Fiveyears = 1;

Disaffection = (IsraelAntiPeace + PAProPeace + ViewsIsraelUnfavorably + ProPalestine)/4;

fiveitems =(toomuchshoahtalk + ownkind + loyaltoIsrael + shady + toomuchpower)/5;

run;

/* This syntax specifies the default proc mixed information criteria ic= q*/
/* To run the following code you must have the GLIMMIX Macro installed*/
/* The following code replicates Table 8.9 and adds the ratio, deviance, and scaled deviance*/



/*This calls the GLMM Macro the source will not be printed  Model 1 */

%inc 'c:\Program Files\glmm800.sas'/nosource;
run;

%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title 'This run applies poisson regression repeated Model 1';
class country ;
model violence0103 = / s;
random country/s ;
),
error = poisson,
link = log);
run;
data bob1; set BOB; proc print; run;



	 /*This calls the GLMM Macro the source will not be printed  Model 2*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = first, procopt=method=reml covtest ratio ic, out=Bob2,
stmts=%str(Title 'This run applies poisson regression repeated Model 2';
class country year ;
model violence0103 = year / s;
random country /s ;
lsmeans year /cl;
),
error = poisson,
link = log);
run;
data bob3; set Bob2; proc print; run;


	 /*This calls the GLMM Macro the source will not be printed  Model 3*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 3';
class country year ManyJewsMuslims ;
model violence0103 = year ManyJewsMuslims / s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
),
error = poisson,
link = log);
run;
data bob1; set BOB; proc print; run;



	 /*This calls the GLMM Macro the source will not be printed Model 4*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;

%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 4';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium / s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;
data bob1; set BOB; proc print; run;



	 /*This calls the GLMM Macro the source will not be printed Model 5*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 5';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium PAProPeace/ s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;
data bob1; set BOB; proc print; run;


	 /*This calls the GLMM Macro the source will not be printed Model 6*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 6';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium PAProPeace DislikesIsrael/ s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;
data bob1; set BOB; proc print; run;



	 /*This calls the GLMM Macro the source will not be printed Model 7*/
%inc 'c:\Program Files\glmm800.sas'/nosource;
run;
%glimmix (data = first, procopt=method=reml covtest ratio ic,out=Bob,
stmts=%str(Title1 'This run applies poisson regression repeated Model 7';
class country year ManyJewsMuslims Belgium;
model violence0103 = year ManyJewsMuslims belgium PAProPeace FiveItems/ s;
random country/s ;
lsmeans year /cl;
lsmeans manyJewsMuslims/cl;
lsmeans belgium/cl;
),
error = poisson,
link = log);
run;
data bob1; set BOB; proc print; run;
	
	/*This ends the code for Table 8.9 using the Glimmix Macro*/
	/*The syntax in this file is copyright by Robert B. Smith  2011 */






















